<?php

class DialogController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->menu;
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','updateStatement','createChildStatement','view'),
				'roles'=>array('admin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model = $this->loadModel($id);

		//only for roots
		if(!empty($model->idRodzica))
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$this->render('view', array(
			'model'=>$model,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Dialog;

		if(isset($_POST['Dialog']))
		{
			$model->attributes = $_POST['Dialog'];

			if($model->save())
				$this->redirect(array('update', 'id'=>$model->id));
		}

		$this->render('create', array(
			'model'=>$model,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreateChildStatement($parentId)
	{
		$model = new Dialog;
		$parentModel = $this->loadModel($parentId);
		$rootModel = $parentModel->getRoot();

		if(isset($_POST['Dialog']))
		{
			$model->attributes = $_POST['Dialog'];
			$model->idRodzica = $parentId;

			if($model->save())
				$this->redirect(array('update', 'id'=>$rootModel->id));
		}

		$this->render('createChildStatement', array(
			'model'=>$model,
			'rootModel'=>$rootModel,
			'parentId'=>$parentId
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
/*
		if(isset($_POST['Lekcja']))
		{
			$model->attributes = $_POST['Lekcja'];

			if($model->save())
				$this->redirect(array('view', 'id'=>$model->id));
		}*/

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdateStatement($id)
	{
		$model = $this->loadModel($id);

		$rootModel = $model->getRoot();

		if(isset($_POST['Dialog']))
		{
			$model->attributes = $_POST['Dialog'];

			if($model->save())
				$this->redirect(array('update', 'id'=>$rootModel->id));
		}

		$this->render('updateStatement',array(
			'model'=>$model,
			'rootModel'=>$rootModel
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$model = $this->loadModel($id);
			$rootModel = $model->getRoot();
			$model->deleteChildren();

			$model = Dialog::model()->findByPk($rootModel->id);
			if(empty($model))
				$this->redirect(array('admin'));

			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('update','id'=>$rootModel->id));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Dialog('search');
		$model->unsetAttributes();

		if(isset($_GET['Dialog']))
			$model->attributes = $_GET['Dialog'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Dialog::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		return $model;
	}
}